

<?php $__env->startSection('title', 'تعديل المهارة'); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">تعديل المهارة</h3>
    </div>
    <form action="<?php echo e(route('admin.skills.update', $skill->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="card-body">
            <!-- Tabs -->
            <ul class="nav nav-tabs mb-4" id="langTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="ar-tab" data-bs-toggle="tab" data-bs-target="#ar" type="button" role="tab" aria-controls="ar" aria-selected="true">العربية</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="en-tab" data-bs-toggle="tab" data-bs-target="#en" type="button" role="tab" aria-controls="en" aria-selected="false">English</button>
                </li>
            </ul>

            <div class="tab-content mb-4" id="langTabContent">
                <!-- Arabic Tab -->
                <div class="tab-pane fade show active" id="ar" role="tabpanel" aria-labelledby="ar-tab">
                    <div class="form-group mb-3">
                        <label for="name_ar">اسم المهارة (عربي)</label>
                        <input type="text" name="name_ar" class="form-control" id="name_ar" value="<?php echo e($skill->getNameArAttribute()); ?>" required>
                    </div>
                </div>

                <!-- English Tab -->
                <div class="tab-pane fade" id="en" role="tabpanel" aria-labelledby="en-tab" dir="ltr">
                     <div class="form-group mb-3">
                        <label for="name_en">Skill Name (English)</label>
                        <input type="text" name="name_en" class="form-control" id="name_en" value="<?php echo e($skill->getNameEnAttribute()); ?>" required>
                    </div>
                </div>
            </div>

            <div class="form-group mb-3">
                <label for="percentage">النسبة المئوية (0-100)</label>
                <input type="number" name="percentage" class="form-control" id="percentage" min="0" max="100" value="<?php echo e($skill->percent); ?>" required>
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">تحديث</button>
            <a href="<?php echo e(route('admin.skills.index')); ?>" class="btn btn-default float-end">إلغاء</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\vipp\Admin dashboard\resources\views/admin/skills/edit.blade.php ENDPATH**/ ?>