<?php
$currentLang = request()->get('lang', 'ar');
app()->setLocale($currentLang);
?>
<!DOCTYPE html>
<!--[if lt IE 7]>      <html dir="<?php echo e($currentLang == 'ar' ? 'rtl' : 'ltr'); ?>" class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html dir="<?php echo e($currentLang == 'ar' ? 'rtl' : 'ltr'); ?>" class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html dir="<?php echo e($currentLang == 'ar' ? 'rtl' : 'ltr'); ?>" class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html dir="<?php echo e($currentLang == 'ar' ? 'rtl' : 'ltr'); ?>" class="no-js"> <!--<![endif]-->

<head>
    <meta charset="utf-8">
    <meta content="text/html; charset=windows-1256" http-equiv="Content-Type">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title><?php echo e($setting->site_name ?? 'ميو فلات - تصميم ذي الصفحة الواحدة'); ?></title>
    <meta name="viewport" content="width=device-width">

    <!-- Favicons -->
    <link rel="shortcut icon" href="<?php echo e($setting && $setting->favicon ? asset($setting->favicon) : asset('icon/favicon.ico')); ?>">
    <link rel="apple-touch-icon-precomposed" href="<?php echo e(asset('icon/apple-touch-icon.png')); ?>">
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo e(asset('icon/apple-touch-icon-57x57.html')); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo e(asset('icon/apple-touch-icon-72x72.html')); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo e(asset('icon/apple-touch-icon-114x114.html')); ?>" />

    <!-- Google Fonts -->
    <link href='http://fonts.googleapis.com/css?family=Raleway:400,500,600,700,300' rel='stylesheet' type='text/css'>
    <link href='http://fonts.googleapis.com/css?family=Pacifico' rel='stylesheet' type='text/css'>

    <!-- Base Stylesheet -->
    <link rel="stylesheet" href="<?php echo e(asset('css/base.css')); ?>">
    <link rel="stylesheet" class="alt" href="<?php echo e(asset('css/theme-default.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/custom_fixes.css')); ?>">
    <style>
        #top-banner { width: 100%; display: block; max-height: 150px; overflow: hidden; }
        #top-banner img { width: 100%; height: 150px; object-fit: cover; display: block; }
        #header { position: sticky; top: 0; z-index: 999; background: #fff; }
        
        /* Except top-banner which needs to be full width */
        #top-banner img { width: 100% !important; }
    </style>

</head>

<body>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($setting && $setting->top_banner): ?>
<div id="top-banner">
    <img src="<?php echo e(asset($setting->top_banner)); ?>" alt="Banner">
</div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>



<div id="pageloader">
    <div class="loader-item">
        <img src="<?php echo e(asset('images/loader-dark.gif')); ?>" alt='loader' />
    </div>
</div>

<!-- Header -->
<header id="header">
    <!-- Top Bar -->
    <section id="top-bar">&nbsp;</section>
    <!-- Top Bar End -->

    <!-- Logo -->
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="text-center">
                    <a href="<?php echo e(route('login')); ?>" class="logo"><img src="<?php echo e($setting && $setting->logo ? asset($setting->logo) : asset('images/logo.png')); ?>" alt="<?php echo e($setting->site_name ?? 'Logo'); ?>"></a>
                </div>
            </div>
        </div>
    </div>
    <!-- Logo End -->

    <!-- Navigation -->
    <div class="navbar" role="navigation">
        <div class="container">
            <div class="navbar-header">
                <button type="button" id="nav-toggle" class="navbar-toggle" data-toggle="collapse" data-target="#main-nav">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
            </div>
            <div id="main-nav" class="collapse navbar-collapse">
                <ul class="nav navbar-nav">
                    <li class="home"><a href="#" class="selected scroll-link" data-id="home"><?php echo e(__('menu.home')); ?></a></li>
                    <li><a href="#" class="scroll-link" data-id="about"><?php echo e(__('menu.about')); ?></a></li>
                    <li><a href="#" class="scroll-link" data-id="services"><?php echo e(__('menu.services')); ?></a></li>
                    <li><a href="#" class="scroll-link" data-id="portoflio"><?php echo e(__('menu.portfolio')); ?></a></li>
                    <li><a href="#" class="scroll-link" data-id="blog"><?php echo e(__('menu.blog')); ?></a></li>
                    <li><a href="#" class="scroll-link" data-id="contact"><?php echo e(__('menu.contact')); ?></a></li>
                    <li><a href="/?lang=ar" onclick="window.location.href='/?lang=ar'; return false;" class="lang-switcher <?php echo e($currentLang == 'ar' ? 'selected' : ''); ?>">العربية</a></li>
                    <li><a href="/?lang=en" onclick="window.location.href='/?lang=en'; return false;" class="lang-switcher <?php echo e($currentLang == 'en' ? 'selected' : ''); ?>">English</a></li>
                </ul>
            </div><!--/.nav-collapse -->
        </div>
    </div>
    <!-- Navigation End -->
</header>

<!-- Header End -->

<!-- News Ticker -->
<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($timelines->count() > 0): ?>
<div class="news-ticker-wrapper" style="overflow: hidden; border-bottom: 3px solid transparent; direction: ltr;">
    <div class="news-ticker" style="white-space: nowrap; display: inline-block; animation: ticker 30s linear infinite; padding-left: 100%;">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $timelines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timeline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <span class="news-item" style="display: inline-block; padding: 10px 30px; font-family: 'Cairo', sans-serif, 'Raleway'; font-size: 16px;">
                <a href="#" style="text-decoration: none;">
                    <?php echo e($timeline->year); ?> - <?php echo e($timeline->title); ?> <i class="fa fa-newspaper-o" style="margin-left: 5px;"></i>
                </a>
            </span>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>
<style>
@keyframes ticker {
    0% { transform: translate3d(0, 0, 0); }
    100% { transform: translate3d(-100%, 0, 0); }
}
</style>
<script>
    function syncTickerWithTheme() {
        // Get 'reference' colors from the theme elements
        var topBarColor = window.getComputedStyle(document.querySelector('#top-bar')).backgroundColor;
        var primaryColor = window.getComputedStyle(document.querySelector('.selected') || document.querySelector('a')).color;
        
        // Use the 'primary' color (often Red #e74c3c) for the ticker background to make it stand out like #top-bar
        // Or follow user request: "footer of timeline" -> maybe dark background?
        // But user said "like the rest". #top-bar is background color.
        
        // Let's use #top-bar background color for Ticker Background? 
        // Actually #top-bar is usually the colored strip.
        // Let's use a Dark Background (hardcoded or from footer?) and use the Theme Color for Text/Border.
        // The Footer has background #303030 (Dark).
        
        var footerBg = window.getComputedStyle(document.querySelector('footer .copyright') || document.querySelector('footer')).backgroundColor;
        
        // Apply to Ticker
        var tickerWrapper = document.querySelector('.news-ticker-wrapper');
        if(tickerWrapper) {
            tickerWrapper.style.backgroundColor = 'rgba(30, 30, 30, 0.9)'; // Keep it dark like footer
            tickerWrapper.style.borderBottomColor = topBarColor; // Use theme color for border
            
            var items = document.querySelectorAll('.news-item a');
            items.forEach(function(item) {
                item.style.color = '#fff'; // White text
                var icon = item.querySelector('i');
                if(icon) icon.style.color = topBarColor; // Icon matches theme
            });
        }
    }

    // Run on load and whenever style switcher is clicked
    window.addEventListener('load', syncTickerWithTheme);
    document.addEventListener('DOMContentLoaded', syncTickerWithTheme);
    
    // Observer for style changes (if switcher doesn't trigger event directly)
    // Or just hook into the switcher click if possible.
    // For now, simple interval check or hook into .styleswitcher clicks
    var switchers = document.querySelectorAll('.styleswitcher a');
    if(switchers) {
        for(var i=0; i<switchers.length; i++) {
             switchers[i].addEventListener('click', function() {
                 setTimeout(syncTickerWithTheme, 100); // Wait for CSS swap
             });
        }
    }
</script>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<!-- News Ticker End -->

<div class="clearfix"></div>
<!-- Slider -->
<section id="home" class="slider-bg">
    <div class="page-slider-wrap">
        <div id="page-slider" >
            <ul>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <!-- SLIDE  -->
                <li data-transition="fade" data-slotamount="7" data-masterspeed="1500" >

                    <!-- MAIN IMAGE -->
                    <img src="<?php echo e(asset($slide->image)); ?>"  alt="<?php echo e($slide->title); ?>"  data-bgfit="scroll" data-bgposition="top center" data-bgrepeat="no-repeat">

                    <!-- LAYER NR. 1 -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($slide->title): ?>
                    <div class="tp-caption slider-title customin customout"
                         data-x="center"
                         data-y="30"
                         data-customin="x:0;y:0;z:0;rotationX:90;rotationY:0;rotationZ:0;scaleX:1;scaleY:1;skewX:0;skewY:0;opacity:0;transformPerspective:200;transformOrigin:50% 0%;"
                         data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:0.75;scaleY:0.75;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
                         data-speed="1000"
                         data-start="500"
                         data-easing="Back.easeInOut"
                         data-endspeed="300"
                         style="color:#fff;font-family:HelveticaNeueLTW20;"><?php echo nl2br(e($slide->title)); ?>

                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <!-- LAYER NR. 2 -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($slide->foreground_image): ?>
                    <div class="tp-caption slider-sub-title sfl"
                         data-x="center"
                         data-y="120"
                         data-speed="1000"
                         data-start="700"
                         data-easing="Back.easeInOut"
                         data-endspeed="300"
                         style="color:#fff;font-family:HelveticaNeueLTW20;">
                         <img src="<?php echo e(asset($slide->foreground_image)); ?>" alt="">
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </ul>
            <div class="tp-bannertimer tp-bottom"></div>
        </div>
    </div>

    <div class="clearfix">&nbsp;</div>
    <div class="container">
        <div class="text-center row">
            <div class="col-md-12 welcome-note">
                <h4><?php echo nl2br(e($setting->welcome_title ?? "هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى .\n\nبداية الكثير من اصحاب الاعمال .")); ?></h4>

                <a href="<?php echo e($setting->welcome_btn_1_link ?? '#'); ?>" class="btn orange scroll-link" data-id="portoflio"><?php echo e($setting->welcome_btn_1_text ?? 'رؤية الاعمال'); ?></a> 
                <a href="<?php echo e($setting->welcome_btn_2_link ?? '#'); ?>" class="btn black scroll-link" data-id="contact"><?php echo e($setting->welcome_btn_2_text ?? 'اتصل بنا'); ?></a>
            </div>
        </div>
    </div>
</section>
<!-- Slider End -->

<!-- About Us -->
<section id="about" class="content">
    <div class="container">
        <div class="row">
            <!--About Page-->
            <div class="col-md-12 text-center">
                <!--Main Heading-->
                <!--Main Heading-->
                <!--Main Heading-->
                <h2 class="page-head"><?php echo e($setting->about_title ?? __('general.about_title_default')); ?></h2>
                <h4><?php echo nl2br(e($setting->about_description ?? __('general.about_desc_default'))); ?></h4>
                <!--Main Heading End-->

                <!--Icon Heading-->
                <div class="icon-head">
                    <i class="fa fa-user"></i>
                </div>
                <!--Icon Heading End-->

                <!--Sub Heading-->
                <!--Sub Heading-->
                <h3><?php echo e($setting->team_title ?? __('general.team_title_default')); ?></h3>
                <h4><?php echo nl2br(e($setting->team_description ?? __('general.team_desc_default'))); ?></h4>
                <!--Sub Heading End-->
                <!--Sub Heading End-->
            </div>
            <!--About Page End-->

            <!--Team Members-->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-sm-3">
                <div class="white-wrap team-wrap">
                    <img src="<?php echo e(asset($member->image)); ?>" alt="<?php echo e($member->name); ?>">
                    <h3><?php echo e($member->name); ?> <span><?php echo e($member->job_title); ?></span></h3>
                    <div class="social-icons">
                        <ul>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($member->twitter): ?> <li><a href="<?php echo e($member->twitter); ?>"><i class="fa fa-twitter"></i></a></li> <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($member->dribbble): ?> <li><a href="<?php echo e($member->dribbble); ?>"><i class="fa fa-dribbble"></i></a></li> <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($member->google_plus): ?> <li><a href="<?php echo e($member->google_plus); ?>"><i class="fa fa-google-plus"></i></a></li> <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($member->facebook): ?> <li><a href="<?php echo e($member->facebook); ?>"><i class="fa fa-facebook"></i></a></li> <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <!--Team Members End-->
            <div class="clearfix"></div>
            <!--Our Skills-->
            <div class="col-md-12 text-center">
                <!--Icon Heading-->
                <div class="icon-head">
                    <i class="fa fa-code"></i>
                </div>
                <!--Icon Heading End-->

                <!--Sub Heading-->
                <h3><?php echo e($setting->skills_title ?? __('general.skills_title_default')); ?></h3>
                <h4><?php echo nl2br(e($setting->skills_description ?? __('general.skills_desc_default'))); ?></h4>
                <!--Sub Heading End-->
            </div>
            <div class="col-md-12">
                <div class="skillbar-wrap">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6">
                        <div class="clearfix">
                            <span class="skillbar-title pull-left"><?php echo e($skill->name); ?></span>
                            <span class="skill-bar-percent pull-right"><?php echo e($skill->percent); ?>%</span>
                        </div>
                        <div class="skillbar" data-percent="<?php echo e($skill->percent); ?>%">
                            <div class="skillbar-bar"></div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>

            <!--Our Skills End-->


        </div>
    </div>

    <!--Page Bottom Spacer-->
    <div class="spacer">&nbsp;</div>
    <!--Page Bottom Spacer End-->
</section>
<!-- About Us End -->

<!-- Services -->
<section id="services" class="content">
    <div class="container">
        <div class="row">
            <!--Services Page-->
            <div class="col-md-12 text-center">
                <!--Main Heading-->
                <h2 class="page-head"><?php echo e($setting->services_title ?? __('general.services_title_default')); ?></h2>
                <h4><?php echo nl2br(e($setting->services_description ?? __('general.services_desc_default'))); ?></h4>
                <!--Main Heading End-->

                <!--Icon Heading-->
                <div class="icon-head">
                    <i class="fa fa-briefcase"></i>
                </div>
                <!--Icon Heading End-->

                <!--Sub Heading-->
                <h3><?php echo e($setting->services_sub_title ?? __('general.services_title_default')); ?></h3>
                <h4><?php echo nl2br(e($setting->services_sub_description ?? __('general.services_desc_default'))); ?></h4>
                <!--Sub Heading End-->
            </div>

            <!--Feature Services-->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-sm-4">
                <div class="white-wrap service-wrap">
                    <div class="service-icon">
                        <i class="<?php echo e($service->icon); ?> fa-2x"></i>
                    </div>
                    <h3><?php echo e($service->title); ?></h3>
                    <p><?php echo nl2br(e($service->description)); ?></p>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <!--Feature Services End-->
            <div class="clearfix"></div>
            <!--Feature Call To Action-->
            <div class="col-md-12 col-lg-12">
                <div class="call-action text-center">
                    <p><?php echo e($setting->cta_text ?? __('general.contact_desc_default')); ?></p>
                    <div>
                        <a href="<?php echo e($setting->cta_button1_link ?? '#'); ?>" class="btn orange"><?php echo e($setting->cta_button1_text ?? __('general.read_more')); ?></a>
                        <a href="<?php echo e($setting->cta_button2_link ?? '#'); ?>" class="btn white"><?php echo e($setting->cta_button2_text ?? __('general.call_us')); ?></a>
                    </div>
                </div>
            </div>
            <!--Feature Call To Action End-->

            <div class="col-md-12 text-center">


                <!--Services Page End-->
            </div>
        </div>

        <!--Page Bottom Spacer-->
        <div class="spacer">&nbsp;</div>
        <!--Page Bottom Spacer End-->
</section>
<!-- Services End -->

<!-- Portoflio -->
<section id="portoflio" class="content">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center">
                <!--Main Heading-->
                <h2 class="page-head"><?php echo e($setting->portfolio_title ?? __('general.portfolio_title_default')); ?></h2>
                <h4><?php echo nl2br(e($setting->portfolio_description ?? __('general.portfolio_desc_default'))); ?></h4>
                <!--Main Heading End-->
            </div>
        </div>
    </div>


    <section id="portfolio-grid">
        <div class="container">
            <div class="row">
                <div class="wrapper wf">
                    <div class="col-md-12">
                        <ul class="unstyled" id="filters">
                            <li class="filter" data-filter="all" data-role="button"><a href="javascript:void(0)"><?php echo e(__('general.all')); ?></a></li>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="filter" data-filter="<?php echo e($category->slug); ?>" data-role="button"><a href="javascript:void(0)"><?php echo e($category->name); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </ul>
                    </div>
                    <div class="clearfix"></div>
                    <ul id="Grid" class="unstyled">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $portfolios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $portfolio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="mix col-sm-3 <?php echo e($portfolio->category->slug ?? ''); ?>" data-sort="data-name">
                            <div class="white-wrap">
                                <div class="image-holder">
                                    <a href="<?php echo e($portfolio->image ? asset($portfolio->image) : asset('images/portfolio/default.jpg')); ?>" class="fancybox" data-fancybox-group="gallery" title="<?php echo e($portfolio->title); ?>">
                                        <span class="item-on-hover"><span class="hover-image"><i class="fa fa-search fa-2x"></i></span></span>
                                        <img src="<?php echo e($portfolio->image ? asset($portfolio->image) : asset('images/portfolio/default.jpg')); ?>" alt="<?php echo e($portfolio->title); ?>">
                                    </a>
                                </div>
                                <div class="text-holder">
                                    <i class="fa fa-picture-o"></i>
                                    <h3><?php echo e($portfolio->title); ?></h3>
                                    <p><?php echo e($portfolio->description); ?></p>
                                </div>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <div class="clearfix"></div>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- END DEMO WRAPPER -->
    <!--Page Bottom Spacer-->
    <div class="spacer">&nbsp;</div>
    <!--Page Bottom Spacer End-->
</section>
<!-- Portoflio End -->

<!-- Our Blog -->
<section id="blog" class="content">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center">
                <!--Main Heading-->
                <h2 class="page-head"><?php echo e($setting->blog_title ?? __('general.blog_title_default')); ?></h2>
                <h4><?php echo nl2br(e($setting->blog_description ?? __('general.blog_desc_default'))); ?></h4>
                <!--Main Heading End-->
            </div>
            <div class="col-md-12">
                <div id="bloglist" class="bloglist blog-grid">

                    <!-- loop starts here -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="blog-entry">
                        <div class="white-wrap">
                            <div class="image-holder">
                                <a href="#" class="fancybox" title="<?php echo e($post->title); ?>">
                                    <span class="item-on-hover"><span class="hover-image"><i class="fa fa-search fa-2x"></i></span></span>
                                    <img src="<?php echo e($post->image ? asset($post->image) : asset('images/blog/default.jpg')); ?>" alt="<?php echo e($post->title); ?>">
                                </a>
                            </div>
                            <div class="text-holder">
                                <i class="fa fa-picture-o"></i>
                                <div class="meta">
                                    <span> <?php echo e($post->published_at ? $post->published_at->format('M Y') : ''); ?> / <?php echo e(__('general.articles')); ?> </span>
                                </div>
                                <h3><a href="#"><?php echo e($post->title); ?></a></h3>
                                <div><?php echo Str::limit(strip_tags($post->content), 150); ?></div>
                                <a href="#" class="btn black"><?php echo e(__('general.read_more')); ?></a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <!-- loop ends here  -->

                </div>
            </div>

            <div class="col-sm-12">
                <a href="#" id="load-more"><?php echo e(__('general.load_more')); ?></a>
            </div>

            <div class="clearfix"></div>
        </div>
    </div>

    <!--Page Bottom Spacer-->
    <div class="spacer">&nbsp;</div>
    <!--Page Bottom Spacer End-->
</section>
<!-- Our Blog End -->

<!-- Contact Us -->
<section id="contact" class="content last">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center">
                <!--Main Heading-->
                <!--Main Heading-->
                <h2 class="page-head"><?php echo e($setting->contact_title ?? __('general.contact_title_default')); ?></h2>
                <h4><?php echo nl2br(e($setting->contact_description ?? __('general.contact_desc_default'))); ?></h4>                <!--Main Heading End-->
            </div>
        </div>
    </div>

    <div class="parallax-area parallax-image" data-stellar-background-ratio="0.1" id="contacr-form">
        <div class="container">
            <div class="row">
                <div class="col-sm-4">
                    <div class="white-wrap">
                        <div class="text-holder">
                            <i class="fa fa-map-marker"></i>
                            <h3><?php echo e(__('general.address')); ?></h3>
                            <div><?php echo e($setting->address); ?></div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="white-wrap">
                        <div class="text-holder">
                            <i class="fa fa-phone"></i>
                            <h3><?php echo e(__('general.call_us')); ?></h3>
                            <div><?php echo e($setting->phone); ?></div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="white-wrap">
                        <div class="text-holder">
                            <i class="fa fa-envelope"></i>
                            <h3><?php echo e(__('general.send_email')); ?></h3>
                            <div><a href="mailto:<?php echo e($setting->email); ?>"><?php echo e($setting->email); ?></a></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <br>
        <div class="container">
            <div class="row">
                <div class="form-div">
                    <div class="col-sm-12">
                        <div id="sucessmessage"> </div>
                    </div>
                    <form id="contact_form" method="post" action="#" />
                    <div class="col-sm-4">
                        <input type="text" placeholder="<?php echo e(__('general.full_name')); ?>" name="الاسم" id="name" class="form-control">
                    </div>
                    <div class="col-sm-4">
                        <input type="text" name="email" placeholder="<?php echo e(__('general.email')); ?>" id="email" class="form-control">
                    </div>
                    <div class="col-sm-4">
                        <input type="text" name="phone" placeholder="<?php echo e(__('general.phone')); ?>" id="phone" class="form-control">
                    </div>
                    <div class="clearfix"></div>
                    <div class="col-sm-12">
                        <textarea name="comment" id="comment" placeholder="<?php echo e(__('general.message')); ?>" class="form-control" rows="3"></textarea>
                    </div>
                    <div class="col-sm-6">
                        <input type="submit" class="btn btn-default" value="<?php echo e(__('general.submit')); ?>" id="submit" />
                    </div>
                    <div class="col-sm-6 text-right">
                        <h5><?php echo e(__('general.response_message')); ?></h5>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <footer>
        <div class="container">
            <div class="text-center">
                <div class="social-icons">
                    <ul>
                        <li><a href="<?php echo e($setting->twitter ?? '#'); ?>"><i class="fa fa-twitter"></i></a></li>
                        <li><a href="#"><i class="fa fa-dribbble"></i></a></li>
                        <li><a href="#"><i class="fa fa-google-plus"></i></a></li>
                        <li><a href="<?php echo e($setting->facebook ?? '#'); ?>"><i class="fa fa-facebook"></i></a></li>
                        <li><a href="#"><i class="fa fa-pinterest"></i></a></li>
                        <li><a href="<?php echo e($setting->linkedin ?? '#'); ?>"><i class="fa fa-linkedin"></i></a></li>
                        <li><a href="#"><i class="fa fa-windows"></i></a></li>
                        <li><a href="#"><i class="fa fa-skype"></i></a></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="copyright text-center">
            © <?php echo e(date('Y')); ?> <span><?php echo e($setting->site_name); ?></span>  : <a href="#"><?php echo e(__('general.and_mobile_apps')); ?></a>
        </div>
    </footer>
</section>
<!-- Contact Us End -->

<div id="back-top">
    <a  class="scroll-link" data-id="home" href="#">
        <i class="fa fa-angle-up"></i>
    </a>
</div>

<div class="styleswitcher" style="left: 0px;">
    <div class="arrow-box"><a class="switch-button open"><i class="fa fa-gear fa-2x"></i></a> </div>
    <h6><?php echo e(__('general.your_color')); ?></h6>
    <ul class="color-scheme">
        <li><a class="blue-theme" rel="<?php echo e(asset('css/theme-blue.css')); ?>" href="#"></a></li>
        <li><a class="cherry-theme" rel="<?php echo e(asset('css/theme-cherry.css')); ?>" href="#"></a></li>
        <li><a class="teal-theme" rel="<?php echo e(asset('css/theme-teal.css')); ?>" href="#"></a></li>
        <li><a class="red-theme" rel="<?php echo e(asset('css/theme-red.css')); ?>" href="#"></a></li>
        <li><a class="pink-theme" rel="<?php echo e(asset('css/theme-pink.css')); ?>" href="#"></a></li>
        <li><a class="green-theme" rel="<?php echo e(asset('css/theme-green.css')); ?>" href="#"></a></li>
        <li><a class="orchid-theme" rel="<?php echo e(asset('css/theme-orchid.css')); ?>" href="#"></a></li>
        <li><a class="jade-theme" rel="<?php echo e(asset('css/theme-jade.css')); ?>" href="#"></a></li>
        <li><a class="skyblue-theme" rel="<?php echo e(asset('css/theme-skyblue.css')); ?>" href="#"></a></li>
        <li><a class="orange-theme" rel="<?php echo e(asset('css/theme-orange.css')); ?>" href="#"></a></li>
        <li><a class="yellow-theme" rel="<?php echo e(asset('css/theme-yellow.css')); ?>" href="#"></a></li>
        <li><a class="blue2-theme" rel="<?php echo e(asset('css/theme-blue2.css')); ?>" href="#"></a></li>

    </ul>
</div>

<!-- jQuery & Helper library -->
<script type="text/javascript" src="<?php echo e(asset('js/jquery-1.10.2.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.cookie.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.appear.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.easing.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/modernizr-latest.js')); ?>"></script>
<script type='text/javascript' src="<?php echo e(asset('js/jquery.fitvids.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/retina.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.fancybox.pack8cbb.js?v=2.1.5')); ?>"></script>
<script type='text/javascript' src="<?php echo e(asset('js/owl.carousel.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.mixitup.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/masonry.pkgd.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.flexslider-min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/stellar.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.validate.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.themepunch.plugins.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.themepunch.revolution.min.js')); ?>"></script>
<script src="https://maps.googleapis.com/maps/api/js?v=3.exp&amp;sensor=false"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.gmap.min.js')); ?>"></script>
<script src="https://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false"></script>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/map-icons.css')); ?>" />
<script src="<?php echo e(asset('js/map-icons.js')); ?>"></script>

<!--scripts for current page -->
<script type="text/javascript" src="<?php echo e(asset('js/theme-custom.js')); ?>"></script>
</body>
</html>



<?php /**PATH D:\vipp\Admin dashboard\resources\views/index.blade.php ENDPATH**/ ?>