

<?php $__env->startSection('title', 'تعديل الشريحة'); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">تعديل الشريحة</h3>
    </div>
    <form action="<?php echo e(route('admin.slides.update', $slide->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="card-body">
            
            <!-- Tabs -->
            <ul class="nav nav-tabs mb-4" id="langTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="ar-tab" data-bs-toggle="tab" data-bs-target="#ar" type="button" role="tab" aria-controls="ar" aria-selected="true">العربية</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="en-tab" data-bs-toggle="tab" data-bs-target="#en" type="button" role="tab" aria-controls="en" aria-selected="false">English</button>
                </li>
            </ul>

             <div class="tab-content mb-4" id="langTabContent">
                <!-- Arabic Tab -->
                <div class="tab-pane fade show active" id="ar" role="tabpanel" aria-labelledby="ar-tab">
                    <div class="form-group mb-3">
                        <label for="title_ar">العنوان (عربي)</label>
                        <input type="text" name="title_ar" class="form-control" id="title_ar" value="<?php echo e($slide->getTitleArAttribute()); ?>">
                    </div>
                </div>
                 <!-- English Tab -->
                <div class="tab-pane fade" id="en" role="tabpanel" aria-labelledby="en-tab" dir="ltr">
                    <div class="form-group mb-3">
                        <label for="title_en">Title (English)</label>
                        <input type="text" name="title_en" class="form-control" id="title_en" value="<?php echo e($slide->getTitleEnAttribute()); ?>">
                    </div>
                </div>
            </div>

            <hr>

            <div class="form-group mb-3">
                <label for="image">صورة الخلفية</label>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($slide->image): ?>
                    <div class="mb-2">
                        <img src="<?php echo e(asset($slide->image)); ?>" width="150" class="img-thumbnail">
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <div class="input-group">
                    <input type="file" name="image" class="form-control" id="image">
                </div>
                <small class="text-muted">اتركها فارغة للإبقاء على الصورة الحالية</small>
            </div>

            <div class="form-group mb-3">
                <label for="foreground_image">الصورة الأمامية</label>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($slide->foreground_image): ?>
                    <div class="mb-2">
                        <img src="<?php echo e(asset($slide->foreground_image)); ?>" width="150" class="img-thumbnail">
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <div class="input-group">
                    <input type="file" name="foreground_image" class="form-control" id="foreground_image">
                </div>
                <small class="text-muted">اتركها فارغة للإبقاء على الصورة الحالية</small>
            </div>

            <div class="form-group mb-3">
                <label for="sort_order">ترتيب الظهور</label>
                <input type="number" name="sort_order" class="form-control" id="sort_order" value="<?php echo e($slide->sort_order); ?>">
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">تحديث</button>
            <a href="<?php echo e(route('admin.slides.index')); ?>" class="btn btn-default float-end">إلغاء</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\vipp\Admin dashboard\resources\views/admin/slides/edit.blade.php ENDPATH**/ ?>