

<?php $__env->startSection('title', 'تعديل المقال'); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">تعديل المقال</h3>
    </div>
    <form action="<?php echo e(route('admin.posts.update', $post->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="card-body">
             <div class="row">
                <div class="col-md-6">
                     <div class="form-group mb-3">
                        <label for="title_en">العنوان (English)</label>
                        <input type="text" name="title_en" class="form-control" id="title_en" value="<?php echo e($post->getTitleEnAttribute()); ?>" required>
                    </div>
                </div>
                 <div class="col-md-6">
                     <div class="form-group mb-3">
                        <label for="title_ar">العنوان (Arabic)</label>
                        <input type="text" name="title_ar" class="form-control" id="title_ar" value="<?php echo e($post->getTitleArAttribute()); ?>" required>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                     <div class="form-group mb-3">
                        <label for="content_en">المحتوى (English)</label>
                        <textarea name="content_en" class="form-control" id="content_en" rows="5"><?php echo e($post->getContentEnAttribute()); ?></textarea>
                    </div>
                </div>
                 <div class="col-md-6">
                     <div class="form-group mb-3">
                        <label for="content_ar">المحتوى (Arabic)</label>
                        <textarea name="content_ar" class="form-control" id="content_ar" rows="5"><?php echo e($post->getContentArAttribute()); ?></textarea>
                    </div>
                </div>
            </div>
            
            <div class="form-group mb-3">
                <label for="published_at">تاريخ النشر</label>
                <input type="date" name="published_at" class="form-control" id="published_at" value="<?php echo e($post->published_at ? $post->published_at->format('Y-m-d') : ''); ?>">
            </div>

            <div class="form-group mb-3">
                <label for="image">الصورة</label>
                 <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($post->image): ?>
                    <div class="mb-2">
                        <img src="<?php echo e(asset($post->image)); ?>" width="150" class="img-thumbnail">
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <div class="input-group">
                    <input type="file" name="image" class="form-control" id="image">
                </div>
                 <small class="text-muted">اتركها فارغة للإبقاء على الصورة الحالية</small>
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">تحديث</button>
            <a href="<?php echo e(route('admin.posts.index')); ?>" class="btn btn-default float-end">إلغاء</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\vipp\Admin dashboard\resources\views/admin/posts/edit.blade.php ENDPATH**/ ?>