

<?php $__env->startSection('title', 'المهارات'); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">إدارة المهارات</h3>
        <div class="card-tools">
            <a href="<?php echo e(route('admin.skills.create')); ?>" class="btn btn-primary btn-sm">
                <i class="bi bi-plus"></i> إضافة  
            </a>
        </div>
    </div>
    <div class="card-body p-0">
        <table class="table table-striped projects">
            <thead>
                <tr>
                    <th style="width: 1%">#</th>
                    <th>اسم المهارة</th>
                    <th>النسبة المئوية</th>
                    <th style="width: 20%">الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr onclick="window.location='<?php echo e(route('admin.skills.edit', $skill->id)); ?>';" style="cursor: pointer;">
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($skill->name); ?></td>
                    <td>
                        <div class="progress progress-xs">
                            <div class="progress-bar bg-success" style="width: <?php echo e($skill->percent); ?>%"></div>
                        </div>
                        <small><?php echo e($skill->percent); ?>%</small>
                    </td>
                    <td class="project-actions text-right">
                        <form action="<?php echo e(route('admin.skills.destroy', $skill->id)); ?>" method="POST" style="display: inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm" onclick="event.stopPropagation(); return confirm('هل أنت متأكد؟')">
                                <i class="bi bi-trash"></i> حذف
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\vipp\Admin dashboard\resources\views/admin/skills/index.blade.php ENDPATH**/ ?>