<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ __('filament-panels::layout.direction') ?? 'ltr' }}" class="layout-fixed sidebar-expand-lg">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>{{ $title ?? config('app.name') }}</title>
    
    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="{{ asset('adminlte/css/adminlte.min.css') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.min.css">
    
    <!-- Filament Styles -->
    @filamentStyles
    @vite('resources/css/app.css')
</head>
<body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <div class="app-wrapper">
        {{-- Header --}}
        <nav class="app-header navbar navbar-expand" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); box-shadow: 0 4px 15px rgba(0,0,0,0.2);">
            <div class="container-fluid">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button" style="color: white;">
                            <i class="bi bi-list"></i>
                        </a>
                    </li>
                </ul>
                
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item dropdown user-menu">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown" style="color: white;">
                            <span class="d-none d-md-inline">{{ auth()->user()->name }}</span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <li class="user-footer">
                                <form method="POST" action="{{ filament()->getLogoutUrl() }}">
                                    @csrf
                                    <button type="submit" class="btn btn-default btn-flat float-end">تسجيل الخروج</button>
                                </form>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </nav>
        
        {{-- Sidebar --}}
        <aside class="app-sidebar shadow" style="background: linear-gradient(180deg, #1e3c72 0%, #2a5298 100%);" data-bs-theme="dark">
            <div class="sidebar-brand">
                <a href="{{ filament()->getUrl() }}" class="brand-link">
                    <span class="brand-text fw-light" style="color: white;">{{ config('app.name') }}</span>
                </a>
            </div>
            
            <div class="sidebar-wrapper">
                <nav class="mt-2">
                    {{ \Filament\Facades\Filament::renderHook('sidebar.start') }}
                    
                    <x-filament-panels::sidebar.index />
                    
                    {{ \Filament\Facades\Filament::renderHook('sidebar.end') }}
                </nav>
            </div>
        </aside>
        
        {{-- Main Content --}}
        <main class="app-main" style="background: rgba(255, 255, 255, 0.85); backdrop-filter: blur(10px); margin: 1rem; border-radius: 1rem;">
            {{ $slot }}
        </main>
    </div>
    
    <!-- AdminLTE JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('adminlte/js/adminlte.js') }}"></script>
    
    @filamentScripts
    @vite('resources/js/app.js')
</body>
</html>
