<?php

namespace App\Filament\Widgets;

use App\Models\User;
use App\Models\Post;
use App\Models\Portfolio;
use App\Models\Service;
use App\Models\Category;
use App\Models\Skill;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class StatsOverview extends BaseWidget
{
    protected static ?int $sort = 0;
    
    protected function getStats(): array
    {
        return [
            Stat::make('المستخدمين', User::count())
                ->description('إجمالي المستخدمين المسجلين')
                ->descriptionIcon('heroicon-m-arrow-trending-up')
                ->color('primary')
                ->chart([7, 3, 4, 5, 6, 3, 5, 3]),
                
            Stat::make('المقالات', Post::count())
                ->description('المقالات المنشورة')
                ->descriptionIcon('heroicon-m-document-text')
                ->color('success')
                ->chart([3, 5, 7, 4, 6, 8, 7, 9]),
                
            Stat::make('الأعمال', Portfolio::count())
                ->description('معرض الأعمال')
                ->descriptionIcon('heroicon-m-photo')
                ->color('danger')
                ->chart([4, 6, 5, 7, 8, 6, 9, 8]),
        ];
    }
}
