<?php

namespace App\Filament\Widgets;

use Filament\Widgets\Widget;
use App\Models\User;
use App\Models\Post;
use App\Models\Service;
use App\Models\Portfolio;

class ColorfulStatsWidget extends Widget
{
    protected string $view = 'filament.widgets.colorful-stats-widget';
    
    protected int | string | array $columnSpan = 'full';
    
    protected static ?int $sort = 1;

    public function getStats(): array
    {
        return [
            [
                'title' => 'إجمالي المستخدمين',
                'value' => User::count(),
                'icon' => 'heroicon-o-users',
                'color' => 'primary',
                'gradient' => true,
                'description' => 'عدد المستخدمين المسجلين',
                'link' => route('filament.admin.resources.users.index'),
            ],
            [
                'title' => 'المقالات',
                'value' => Post::count(),
                'icon' => 'heroicon-o-document-text',
                'color' => 'success',
                'gradient' => true,
                'description' => 'إجمالي المقالات المنشورة',
                'link' => route('filament.admin.resources.posts.index'),
            ],
            [
                'title' => 'الخدمات',
                'value' => Service::count(),
                'icon' => 'heroicon-o-briefcase',
                'color' => 'warning',
                'gradient' => true,
                'description' => 'الخدمات المتاحة',
                'link' => route('filament.admin.resources.services.index'),
            ],
            [
                'title' => 'الأعمال',
                'value' => Portfolio::count(),
                'icon' => 'heroicon-o-photo',
                'color' => 'danger',
                'gradient' => true,
                'description' => 'معرض الأعمال',
                'link' => route('filament.admin.resources.portfolios.index'),
            ],
        ];
    }
}
