<?php

namespace App\Filament\Resources\Settings;

use App\Filament\Resources\Settings\Pages\CreateSetting;
use App\Filament\Resources\Settings\Pages\EditSetting;
use App\Filament\Resources\Settings\Pages\ListSettings;
use App\Filament\Resources\Settings\Tables\SettingsTable;
use App\Models\Setting;
use BackedEnum;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Tabs;
use Filament\Forms\Components\Tabs\Tab;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class SettingResource extends Resource
{
    protected static ?string $model = Setting::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $recordTitleAttribute = 'site_name';

    protected static ?string $modelLabel = 'إعداد';
    protected static ?string $pluralModelLabel = 'الإعدادات';
    protected static string | \UnitEnum | null $navigationGroup = 'النظام';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                Tabs::make('Translations')
                    ->tabs([
                        Tab::make('العربية')
                            ->schema([
                                Section::make('عام')
                                    ->schema([
                                        TextInput::make('site_name_ar')->label('اسم الموقع'),
                                        TextInput::make('address_ar')->label('العنوان'),
                                        TextInput::make('copyright_ar')->label('حقوق النشر'),
                                    ])->columns(2),

                                Section::make('ترحيب (Welcome)')
                                    ->schema([
                                        TextInput::make('welcome_title_ar')->label('عنوان الترحيب'),
                                        TextInput::make('welcome_subtitle_ar')->label('العنوان الفرعي'),
                                        TextInput::make('welcome_btn_1_text_ar')->label('نص الزر 1'),
                                        TextInput::make('welcome_btn_2_text_ar')->label('نص الزر 2'),
                                    ])->columns(2),

                                Section::make('من نحن (About)')
                                    ->schema([
                                        TextInput::make('about_title_ar')->label('عنوان من نحن'),
                                        Textarea::make('about_description_ar')->label('وصف من نحن')->rows(4),
                                    ]),

                                Section::make('فريق العمل (Team)')
                                    ->schema([
                                        TextInput::make('team_title_ar')->label('عنوان الفريق'),
                                        Textarea::make('team_description_ar')->label('وصف الفريق')->rows(4),
                                    ]),

                                Section::make('المهارات (Skills)')
                                    ->schema([
                                        TextInput::make('skills_title_ar')->label('عنوان المهارات'),
                                        Textarea::make('skills_description_ar')->label('وصف المهارات')->rows(4),
                                    ]),

                                Section::make('الخدمات (Services)')
                                    ->schema([
                                        TextInput::make('services_title_ar')->label('عنوان الخدمات'),
                                        Textarea::make('services_description_ar')->label('وصف الخدمات')->rows(4),
                                        TextInput::make('services_sub_title_ar')->label('عنوان الخدمات الفرعي'),
                                        Textarea::make('services_sub_description_ar')->label('وصف الخدمات الفرعي')->rows(4),
                                    ]),

                                Section::make('أعمالنا (Portfolio)')
                                    ->schema([
                                        TextInput::make('portfolio_title_ar')->label('عنوان المعرض'),
                                        Textarea::make('portfolio_description_ar')->label('وصف المعرض')->rows(4),
                                    ]),

                                Section::make('المدونة (Blog)')
                                    ->schema([
                                        TextInput::make('blog_title_ar')->label('عنوان المدونة'),
                                        Textarea::make('blog_description_ar')->label('وصف المدونة')->rows(4),
                                    ]),
                                
                                Section::make('تواصل معنا (Contact)')
                                    ->schema([
                                        TextInput::make('contact_title_ar')->label('عنوان تواصل معنا'),
                                        Textarea::make('contact_description_ar')->label('وصف تواصل معنا')->rows(4),
                                    ]),

                                Section::make('الدعوة لاتخاذ إجراء (CTA)')
                                    ->schema([
                                        Textarea::make('cta_text_ar')->label('نص الدعوة')->rows(4),
                                        TextInput::make('cta_button1_text_ar')->label('نص الزر 1'),
                                        TextInput::make('cta_button2_text_ar')->label('نص الزر 2'),
                                    ])->columns(3),
                            ]),

                        Tab::make('English')
                            ->schema([
                                Section::make('General')
                                    ->schema([
                                        TextInput::make('site_name_en')->label('Site Name'),
                                        TextInput::make('address_en')->label('Address'),
                                        TextInput::make('copyright_en')->label('Copyright'),
                                    ])->columns(2),

                                Section::make('Welcome')
                                    ->schema([
                                        TextInput::make('welcome_title_en')->label('Welcome Title'),
                                        TextInput::make('welcome_subtitle_en')->label('Welcome Subtitle'),
                                        TextInput::make('welcome_btn_1_text_en')->label('Button 1 Text'),
                                        TextInput::make('welcome_btn_2_text_en')->label('Button 2 Text'),
                                    ])->columns(2),

                                Section::make('About')
                                    ->schema([
                                        TextInput::make('about_title_en')->label('About Title'),
                                        Textarea::make('about_description_en')->label('About Description')->rows(4),
                                    ]),

                                Section::make('Team')
                                    ->schema([
                                        TextInput::make('team_title_en')->label('Team Title'),
                                        Textarea::make('team_description_en')->label('Team Description')->rows(4),
                                    ]),

                                Section::make('Skills')
                                    ->schema([
                                        TextInput::make('skills_title_en')->label('Skills Title'),
                                        Textarea::make('skills_description_en')->label('Skills Description')->rows(4),
                                    ]),

                                Section::make('Services')
                                    ->schema([
                                        TextInput::make('services_title_en')->label('Services Title'),
                                        Textarea::make('services_description_en')->label('Services Description')->rows(4),
                                        TextInput::make('services_sub_title_en')->label('Services Subtitle'),
                                        Textarea::make('services_sub_description_en')->label('Services Sub Description')->rows(4),
                                    ]),

                                Section::make('Portfolio')
                                    ->schema([
                                        TextInput::make('portfolio_title_en')->label('Portfolio Title'),
                                        Textarea::make('portfolio_description_en')->label('Portfolio Description')->rows(4),
                                    ]),

                                Section::make('Blog')
                                    ->schema([
                                        TextInput::make('blog_title_en')->label('Blog Title'),
                                        Textarea::make('blog_description_en')->label('Blog Description')->rows(4),
                                    ]),
                                
                                Section::make('Contact')
                                    ->schema([
                                        TextInput::make('contact_title_en')->label('Contact Title'),
                                        Textarea::make('contact_description_en')->label('Contact Description')->rows(4),
                                    ]),

                                Section::make('CTA')
                                    ->schema([
                                        Textarea::make('cta_text_en')->label('CTA Text')->rows(4),
                                        TextInput::make('cta_button1_text_en')->label('Button 1 Text'),
                                        TextInput::make('cta_button2_text_en')->label('Button 2 Text'),
                                    ])->columns(3),
                            ]),
                    ])->columnSpanFull(),
                
                // Keep existing non-translatable fields if any, or general ones like Logo
                Section::make('صور (Images)')
                    ->schema([
                        FileUpload::make('logo')->label('الشعار (Logo)')->image()->directory('settings'),
                        FileUpload::make('favicon')->label('أيقونة الموقع (Favicon)')->image()->directory('settings'),
                        FileUpload::make('top_banner')->label('بانر علوي')->image()->directory('settings'),
                    ])->columns(3),

                Section::make('معلومات الاتصال (Contact Info)')
                    ->schema([
                       TextInput::make('email')->label('البريد الإلكتروني')->email(),
                       TextInput::make('phone')->label('رقم الهاتف'),
                    ])->columns(2),
                    
                 Section::make('روابط التواصل الاجتماعي (Social Media)')
                    ->schema([
                       TextInput::make('facebook')->label('Facebook'),
                       TextInput::make('twitter')->label('Twitter'),
                       TextInput::make('linkedin')->label('LinkedIn'),
                       // Add others if they exist in DB, checking index.blade.php for $setting->...
                       // index.blade.php uses $member->dribbble etc, but for settings footer:
                       // twitter, facebook, linkedin are used.
                    ])->columns(3),
            ]);
    }

    public static function table(Table $table): Table
    {
        return SettingsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListSettings::route('/'),
            'create' => CreateSetting::route('/create'),
            'edit' => EditSetting::route('/{record}/edit'),
        ];
    }
}
