<?php

namespace App\Filament\Resources\Portfolios;

use App\Filament\Resources\Portfolios\Pages\ManagePortfolios;
use App\Models\Portfolio;
use BackedEnum;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Get;
use Filament\Forms\Set;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Support\Str;

class PortfolioResource extends Resource
{
    protected static ?string $model = Portfolio::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $recordTitleAttribute = 'title';

    protected static ?string $modelLabel = 'عمل';
    protected static ?string $pluralModelLabel = 'معرض الأعمال';
    protected static string | \UnitEnum | null $navigationGroup = 'إدارة المحتوى';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                FileUpload::make('image')
                    ->label('الصورة')
                    ->image()
                    ->directory('portfolios')
                    ->columnSpanFull(),
                Select::make('category_id')
                    ->label('التصنيف')
                    ->relationship('category', 'name')
                    ->preload()
                    ->searchable()
                    ->createOptionForm([
                        \Filament\Forms\Components\Tabs::make('Translations')
                            ->tabs([
                                \Filament\Forms\Components\Tabs\Tab::make('العربية')
                                    ->schema([
                                        TextInput::make('name_ar')->label('الاسم (عربي)')->required()->live(onBlur: true)
                                            ->afterStateUpdated(fn ($set, $state) => $set('slug_ar', Str::slug($state))),
                                        TextInput::make('slug_ar')->label('Slug عربي')->required(),
                                    ]),
                                \Filament\Forms\Components\Tabs\Tab::make('English')
                                    ->schema([
                                        TextInput::make('name_en')->label('Name (English)')->required()->live(onBlur: true)
                                            ->afterStateUpdated(fn ($set, $state) => $set('slug_en', Str::slug($state))),
                                        TextInput::make('slug_en')->label('Slug English')->required(),
                                    ]),
                            ]),
                    ])
                    ->columnSpanFull(),
                \Filament\Schemas\Components\Tabs::make('Translations')
                    ->tabs([
                        \Filament\Schemas\Components\Tabs\Tab::make('العربية')
                            ->schema([
                                TextInput::make('title_ar')
                                    ->label('العنوان (عربي)')
                                    ->required(),
                                Textarea::make('description_ar')
                                    ->label('الوصف (عربي)')
                                    ->columnSpanFull(),
                            ]),
                        \Filament\Schemas\Components\Tabs\Tab::make('English')
                            ->schema([
                                TextInput::make('title_en')
                                    ->label('Title (English)')
                                    ->required(),
                                Textarea::make('description_en')
                                    ->label('Description (English)')
                                    ->columnSpanFull(),
                            ]),
                    ])->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('title')
            ->columns([
                ImageColumn::make('image')
                    ->label('الصورة'),
                TextColumn::make('title')
                    ->label('العنوان')
                    ->searchable(),
                TextColumn::make('category.name')
                    ->label('التصنيف')
                    ->searchable(),
                TextColumn::make('created_at')
                    ->label('تاريخ الإنشاء')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->label('تاريخ التعديل')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
                DeleteAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => ManagePortfolios::route('/'),
        ];
    }
}
