<?php

namespace App\Filament\Resources\Members;

use App\Filament\Resources\Members\Pages\ManageMembers;
use App\Models\Member;
use BackedEnum;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class MemberResource extends Resource
{
    protected static ?string $model = Member::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static string | \UnitEnum | null $navigationGroup = 'من نحن';

    protected static ?string $modelLabel = 'عضو';

    protected static ?string $pluralModelLabel = 'فريق العمل';

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                FileUpload::make('image')
                    ->label('الصورة')
                    ->image()
                    ->directory('members'),
                \Filament\Schemas\Components\Tabs::make('Translations')
                    ->tabs([
                        \Filament\Schemas\Components\Tabs\Tab::make('العربية')
                            ->schema([
                                TextInput::make('name_ar')->label('الاسم (عربي)')->required(),
                                TextInput::make('job_title_ar')->label('المسمى الوظيفي (عربي)'),
                            ]),
                        \Filament\Schemas\Components\Tabs\Tab::make('English')
                            ->schema([
                                TextInput::make('name_en')->label('Name (English)')->required(),
                                TextInput::make('job_title_en')->label('Job Title (English)'),
                            ]),
                    ])->columnSpanFull(),
                TextInput::make('facebook')
                    ->label('فيسبوك'),
                TextInput::make('twitter')
                    ->label('تويتر'),
                TextInput::make('google_plus')
                    ->label('جوجل بلس'),
                TextInput::make('dribbble')
                    ->label('دريببل'),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                ImageColumn::make('image')
                    ->label('الصورة'),
                TextColumn::make('name')
                    ->label('الاسم')
                    ->searchable(),
                TextColumn::make('job_title')
                    ->label('المسمى الوظيفي')
                    ->searchable(),
                TextColumn::make('facebook')
                    ->label('فيسبوك')
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('twitter')
                    ->label('تويتر')
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('google_plus')
                    ->label('جوجل بلس')
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('dribbble')
                    ->label('دريببل')
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
                DeleteAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => ManageMembers::route('/'),
        ];
    }
}
